import java.awt.Frame;
import java.awt.Dialog;
import java.awt.Button;
import java.awt.Event;
import java.awt.Font;
import java.awt.Panel;
import java.awt.Label;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import graphics.Slider;
import java.awt.CheckboxGroup;
import java.awt.Checkbox;


public class ChannelProperties extends Dialog {
    Button  m_ButtonOK;
    Computer m_Computer;
    Checkbox m_Model1;
    Checkbox m_Model2;
    Checkbox m_Model3;
    GaussSlider  m_Slider;

    public ChannelProperties(Frame frame) {
        super(frame,false);
        this.setLayout(new BorderLayout(15,15));
        // Set Title
        setTitle("Channel's Properties");
        // Selection Radiobuttons
        CheckboxGroup cbg = new CheckboxGroup();
        Panel p = new Panel();
        p.setLayout(new FlowLayout(FlowLayout.LEFT,30,10));
        p.add(new FontLabel("Error Model","Helvetica",Font.BOLD,20,180,30));
        p.add(m_Model1 = new Checkbox("Error Free",cbg,false));
        p.add(m_Model2 = new Checkbox("Gauss with error rate:",cbg,true));
        p.add(m_Slider = new GaussSlider());
        p.add(m_Model3 = new Checkbox("selectable",cbg,true));
        m_Slider.SetHeight(40);
        m_Slider.SetWidth(100);
        m_Slider.SetMinimum(0);
        m_Slider.SetMaximum(100);
        this.add("Center",p);
        // OK Button
        p = new Panel();
        p.setLayout(new FlowLayout(FlowLayout.CENTER,15,15));
        p.add(m_ButtonOK = new Button("Ok"));
        this.add("South",p);
    }

    public boolean action(Event e, Object arg) {
        if (e.target instanceof Button) {
            this.hide();
            return(true);
        }
        if (e.target == m_Model1) {
            Global.channel.model(0);
            return(true);
        }
        if (e.target == m_Model2) {
            Global.channel.model(1);
            return(true);
        }
        if (e.target == m_Model3) {
            Global.channel.model(2);
            return(true);
        }
        return(false);
    }
    public void show() {
        super.show();
        switch (Global.channel.model()) {
        case 0:
            m_Model1.setState(true);
            break;
        case 1:
            m_Model2.setState(true);
            break;
        case 2:
            m_Model3.setState(true);
            break;
        }
        m_Slider.SetValue((int)(Global.channel.m_dDestroyP*100));
    }

}

class GaussSlider	extends	Slider {
	protected void Motion()	{
		Global.channel.m_dDestroyP = (double)GetValue()/100;
	}
}
